<?php

/**
 * Plugin Name: Commandify
 * Plugin URI: https://wprigel.com/commandify
 * Description: Command palette for WordPress admin - keyboard-first navigation and actions
 * Version: 1.0.0
 * Requires at least: 6.2
 * Requires PHP: 7.4
 * Author: WP Rigel
 * Author URI: https://wprigel.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: commandify
 * Domain Path: /languages
 *
 *
 * @package Commandify
 */
namespace WpRigel\Commandify;

defined( 'ABSPATH' ) || exit;
define( 'COMMANDIFY_VERSION', '1.0.0' );
define( 'COMMANDIFY_FILE', __FILE__ );
define( 'COMMANDIFY_PATH', plugin_dir_path( __FILE__ ) );
define( 'COMMANDIFY_URL', plugin_dir_url( __FILE__ ) );
/**
 * Load Composer autoloader first
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Load Freemius SDK
 */
if ( !function_exists( 'commandify_fs' ) ) {
    // Create a helper function for easy SDK access.
    function commandify_fs() {
        global $commandify_fs;
        if ( !isset( $commandify_fs ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_21828_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_21828_MULTISITE', true );
            }
            // Include Freemius SDK.
            // SDK is auto-loaded through Composer
            $commandify_fs = fs_dynamic_init( array(
                'id'             => '21828',
                'slug'           => 'commandify',
                'type'           => 'plugin',
                'public_key'     => 'pk_1e1fab9ab040c4629523e25a90846',
                'is_premium'     => false,
                'has_addons'     => false,
                'has_paid_plans' => true,
                'menu'           => array(
                    'slug'    => 'commandify-settings',
                    'account' => false,
                    'contact' => false,
                    'support' => false,
                    'parent'  => array(
                        'slug' => 'options-general.php',
                    ),
                ),
                'is_live'        => true,
            ) );
        }
        //end if
        return $commandify_fs;
    }

    // Init Freemius.
    commandify_fs();
    // Signal that SDK was initiated.
    do_action( 'commandify_fs_loaded' );
}
//end if
// Load plugin functions early.
require_once COMMANDIFY_PATH . 'includes/functions.php';
/**
 * Load core command files - must load after textdomain, before Registry
 */
function load_command_files() {
    require_once COMMANDIFY_PATH . 'includes/core-commands/navigation-commands.php';
    require_once COMMANDIFY_PATH . 'includes/core-commands/action-commands.php';
    require_once COMMANDIFY_PATH . 'includes/core-commands/search-commands.php';
    require_once COMMANDIFY_PATH . 'includes/core-commands/installation-commands.php';
    require_once COMMANDIFY_PATH . 'includes/core-commands/plugin-theme-commands.php';
    require_once COMMANDIFY_PATH . 'includes/core-commands/user-commands.php';
}

add_action( 'plugins_loaded', __NAMESPACE__ . '\\load_command_files', 2 );
/**
 * Initialize plugin - after command files are loaded.
 */
function early_init() {
    // Initialize core classes.
    Registry::get_instance();
    RestApi::init();
    Assets::init();
    Cache::init_hooks();
    Settings::get_instance();
}

add_action( 'plugins_loaded', __NAMESPACE__ . '\\early_init', 3 );
/**
 * Activation hook
 */
function activate() {
    Cache::clear();
}

register_activation_hook( __FILE__, __NAMESPACE__ . '\\activate' );
/**
 * Deactivation hook
 */
function deactivate() {
    Cache::clear();
}

register_deactivation_hook( __FILE__, __NAMESPACE__ . '\\deactivate' );
if ( function_exists( 'commandify_fs' ) && commandify_fs()->is__premium_only() ) {
    /**
     * Load Pro features if available
     *
     * Pro features are loaded after free version is initialized
     * Free version will work normally if pro folder doesn't exist
     * Pro features only load if user has a valid license
     */
    function load_pro_features() {
        $pro_bootstrap = COMMANDIFY_PATH . 'pro/bootstrap.php';
        // Check if pro folder exists.
        if ( !file_exists( $pro_bootstrap ) ) {
            return;
        }
        // Load pro bootstrap.
        require_once $pro_bootstrap;
        // Initialize pro features.
        \WpRigel\Commandify\Pro\Bootstrap::init();
    }

    add_action( 'plugins_loaded', __NAMESPACE__ . '\\load_pro_features', 100 );
}
//end if