<?php
namespace WpRigel\Commandify;

defined( 'ABSPATH' ) || exit;

/**
 * Register a command
 */
function commandify_register_command( $command ) {
	$result = Registry::get_instance()->register_command( $command );
	return $result;
}

/**
 * Get registry instance
 */
function commandify() {
	return Registry::get_instance();
}

/**
 * Check if commandify is enabled for current user
 */
function commandify_is_enabled() {
	return is_admin() && current_user_can( 'read' );
}

/**
 * Check if Pro version is active
 *
 * @return bool True if pro features are available
 */
function commandify_is_pro() {
	return defined( 'COMMANDIFY_PRO_VERSION' );
}

/**
 * Check if specific pro feature is available
 *
 * @param string $feature Feature name
 * @return bool True if feature is available
 */
function commandify_has_pro_feature( $feature ) {
	if ( ! commandify_is_pro() ) {
		return false;
	}

	$available_features = array(
		'smart_default_view',
		// More features will be added here as we build them.
	);

	return in_array( $feature, $available_features, true );
}
